float alpha = float( PREFIX(alpha) );
float aPercent = PREFIX(aPercent); 
float clip_byte(float x)
{
	if(x<1.0)
		return 0.0;
	else
	{	
		if (x<2.0)
			return x - 1.0;
		else 
			return 1.0;
	}
		
}


vec4 FUNCNAME(vec2 tc) 
{
	vec4 orig = INPUT(tc);
	vec3 texel = orig.rgb;
     
   	float lowest = 0.0;
	float hight = 0.5;
	
	float W = iResolution.x;
	float aDepth = float( int(aPercent)/ 12 + 1)* W/640.0;
	
	vec4 outColor;
	vec4 colA = INPUT(tc );
	vec4 colB = INPUT(vec2( tc.x + float(aDepth)/W, tc.y) );
	
	if(tc.x * W  < W- aDepth)
	{
		float aValueX = colA.z + colA.y + colA.x + colA.y;
		float aValueI = colB.z + colB.y + colB.x + colB.y;
		aValueX = aValueX - aValueI;
		float gray = clip_byte(aValueX/4.0 + 1.5);
		outColor.xyz = vec3(gray);
		outColor.a = colA.a;
		
	}else{
		outColor.xyz = vec3(0.5);
		outColor.a = colA.a;
	}
	float factor = float(alpha)/100.0;
	return colA*(1.0 - factor) + outColor*(factor);
}
